indexing

	description: "[
					Circle that wont scale when zooming in
					EV_CANVAS, threfore a spot
					]"
	status:	"See notice at end of class"
	author: "Till G. Bay"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

class DRAWABLE_SPOT inherit
	
	DRAWABLE_OBJECT

create

	make

feature -- Creation

	make (a_center: like center) is
			-- Create a circle that does not scale at `a_center'.
		require
			a_center_not_void: a_center /= Void
		do
			set_width (default_width)
			set_color (create {EV_COLOR}.make_with_rgb (0.0,0.0,0.0))
			set_diameter (default_diameter)
			set_center (a_center)
		ensure
			width_set: width = default_width
			diameter_set: diameter = default_diameter
			center_set: center_position = a_center
		end
		
feature -- Commands

	set_filled is
			-- Fille the circle.
			do
				filled:= True
			ensure
				filled_true: filled
			end

	set_width (a_width: like width)  is
			-- Set the circle's edge width to `a_width'.
			do
				width:= a_width
			ensure
				new_width: width = a_width
			end
			
	set_diameter (a_diameter: like diameter) is
			-- Set the circle's diameter to `a_diameter'.
			do 
				diameter := a_diameter
			ensure
				new_diameter: diameter = a_diameter
			end
			
	set_center (a_center: like center) is
			-- Set the center of the spot to `a_center'.
			require
				a_center_not_void: a_center /= Void
			do
				center_position := a_center
			ensure
				new_center: center_position = a_center
			end

feature {CANVAS} -- Display

	bounding_box: REAL_RECTANGLE is
			-- The bounding-box of the spot
		do
			create Result.make (center, center)
		end

	draw_object is
			-- Draw the spot
		local
			scaled_center: EV_COORDINATE
		do
			scaled_center := real_to_integer_coordinate (center)
			canvas.set_line_width (width)
			if
				filled
			then
				canvas.fill_ellipse (scaled_center.x - (diameter / 2).rounded, 
									 scaled_center.y - (diameter / 2).rounded, 
									 diameter, diameter)
			else
				canvas.draw_ellipse (scaled_center.x - (diameter / 2).rounded, 
									 scaled_center.y - (diameter / 2).rounded, 
									 diameter, diameter)	
			end
		end

feature {NONE} -- Implementation

	diameter : INTEGER
			-- The diameter of the spot
		
	Default_diameter: INTEGER is 5
			-- The default diameter of the spot

	filled: BOOLEAN
			-- Fill flag
		
	width: INTEGER
			-- The width of the spot's edge
		
	Default_width: INTEGER is 1
			-- The default width of the spot's edge

	center_position : REAL_COORDINATE
			-- Center attribute 
		
	center : REAL_COORDINATE is
			-- Center feature used so we can overwrite
		do
			Result := center_position
		end

invariant
	
	width_not_void: width /= Void
	diameter_not_void: diameter /= Void
	center_position_not_void: center_position /= Void

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Till G. Bay <tillbay@student.ethz.ch>
--|
--|--------------------------------------------------------
