indexing

	description: "Parent class for all animatable Objects."
	status:	"See notice at end of class"
	author: "Till G. Bay"
	date: "$Date: 2004/08/25 12:03:42 $"
	revision: "$Revision: 1.2 $"

deferred class ANIMATABLE inherit

	TIMEABLE
	
feature -- Status report

	is_ready: BOOLEAN is
			-- Is animatable object set up correctly?
		do
			Result := keyframes /= Void and then not keyframes.is_empty
		end

feature -- Status setting

	set_keyframes (a_keyframe_list: like keyframes) is
			-- Set `keyframes' to `a_keyframe_list' 
			-- and move cursor at beginning.
		require
			a_keyframe_list_not_void: a_keyframe_list /= Void
		do
			keyframes := a_keyframe_list
			keyframes.start
		ensure
			new_keyframes: keyframes = a_keyframe_list
			cursor_at_beginning: keyframes.isfirst
		end
		
feature -- Basic operations

	execute_timed_action (t: INTEGER) is
			-- Execute action at time `t'.
		do
			if t <= keyframes.last.time then
				redraw
			else
				suspend
			end
		end

	reset is
			-- Reset animatable object.
		do
			keyframes.start
		end

feature {NONE} -- Implementation

	keyframes: ARRAYED_LIST [KEYFRAME]
			-- List of keyframes

	position: REAL_COORDINATE is
			-- The position of the animatable object
		require	
			keyframes_not_void: keyframes /= Void
			keyframes_not_empty: not keyframes.is_empty
			no_void_keyframe: not keyframes.has (Void)
			timeline_not_void: timeline /= Void
		local
			current_time: INTEGER
			t: REAL
			t_lower_keyframe: INTEGER
			t_upper_keyframe: INTEGER
			position_lower_keyframe: REAL_COORDINATE
			position_upper_keyframe: REAL_COORDINATE
		do
			current_time := timeline.time
			from
				
			until
				keyframes.index = keyframes.count or keyframes.item.time > current_time
			loop
				keyframes.forth
			end
			if not keyframes.isfirst then
				keyframes.back
			end

			t_lower_keyframe := keyframes.item.time
			position_lower_keyframe := keyframes.item.location
			keyframes.forth
			t_upper_keyframe := keyframes.item.time
			position_upper_keyframe := keyframes.item.location
			if (t_upper_keyframe - t_lower_keyframe) /= 0 then
				t := (current_time - t_lower_keyframe) / (t_upper_keyframe - t_lower_keyframe)
			else 
				t := 1.0
			end
			if t > 1.0 then
				timeline.suspend (Current)
				t:= 1.0
			end
			Result := ((position_upper_keyframe - position_lower_keyframe) * t) + position_lower_keyframe
		end

	redraw is
			-- Redraw animatable object.
		require
			ready: is_ready
		deferred
		end

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Till G. Bay <tillbay@student.ethz.ch>
--|
--|--------------------------------------------------------
