indexing
	description: 
		"[
			Concrete factory for displayers 
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.2 $"

class CONCRETE_DISPLAYER_FACTORY inherit
	
	DISPLAYER_FACTORY
	
feature -- Factory features

	build_city_displayer (a_city: CITY) is
			-- Build new displayer for `a_city'.
		do
			create new_city_displayer.make (a_city)
		end

	build_line_displayer (a_line: LINE) is
			-- Build new displayer for `a_line'.
		do
			create new_line_displayer.make (a_line)
		end
		
	build_place_displayer (a_place: PLACE) is
			-- Build new displayer for `a_place'.
		do
			create new_place_displayer.make (a_place)
		end

	build_link_displayer (a_link: LINK) is
			-- Build new displayer for `a_link'.
		do
			create new_link_displayer.make (a_link)
		end
		
	build_station_displayer (a_station: STATION) is
			-- Build new displayer for `a_station'.
		do
			create new_station_displayer.make (a_station)
		end
		
feature -- Access

	new_city_displayer: CITY_DISPLAYER
			-- City displayer created by a call to `build_city_displayer'

	new_line_displayer: LINE_DISPLAYER
			-- Line displayer created by a call to `build_line_displayer'

	new_link_displayer: LINK_DISPLAYER
			-- Link displayer created by a call to `build_link_displayer'

	new_place_displayer: PLACE_DISPLAYER
			-- Place displayer created by a call to `build_place_displayer'

	new_station_displayer: PLACE_DISPLAYER
			-- Station displayer created by a call to `build_station_displayer'

end -- class CONCRETE_DISPLAYER_FACTORY

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
