indexing
	description: 
		"[
			Shortest paths calculated with one of the shortest path calculators.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.2 $"

class SHORTEST_PATH [G -> HASHABLE, H] inherit
	
	LINKED_LIST [EDGE [G, H]]
		export {NONE}
			put_front, 
			extend, 
			put_left, 
			put_right, 
			replace, 
			merge_left, 
			merge_right, 
			remove, 
			remove_left, 
			remove_right, 
			copy,
			append, 
			fill, 
			force, 
			put, 
			put_i_th, 
			prune_all, 
			prune, 
			swap
		end
	
create
	make
	
feature -- Access

	from_node: G is
			-- Key of start node of shortest path
		require
			edges_not_empty: not is_empty
		do
			Result := first.source_key
		end
	
	to_node: G is
			-- Key of end node of shortest path
		require
			edges_not_empty: not is_empty
		do
			Result := last.target_key
		end

feature -- Basic operations

	put_edge_end (an_edge: EDGE [G, H]) is
			-- Append edge `an_edge' to the shortest path.
		require
			an_edge_fits: not is_empty implies last.target_key = an_edge.source_key
		do
			extend (an_edge)
		ensure
			one_more: count = old count + 1
			new_is_last: last = an_edge
		end	
	
	put_edge_front (an_edge: EDGE [G, H]) is
			-- Prepend edge `an_edge' to the shortest path.
		require
			an_edge_fits: not is_empty implies first.source_key = an_edge.target_key
		do
			put_front (an_edge)
		ensure
			one_more: count = old count + 1
			new_is_first: first = an_edge
		end

end -- class SHORTEST_PATH

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
