indexing
	description: 
		"[
			Transportation networks in a city (e.g. streets, bus network, light rail network, etc.). 
			They may also be of mixed type.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class NETWORK inherit
	
	GRAPH [PLACE, LINK]
		rename 
			add_edge as add_link,
			add_node as add_place
		export 
			{NONE} all
			{ANY} add_link, 
			add_place, 
			start, 
			forth, 
			item_for_iteration, 
			off, 
			make
		end		

create 
	make

feature -- Attributes

	lines: LINKED_LIST [LINE]
			-- List of all the lines
	
feature -- Basic operations

	outgoing_links (a_place: PLACE): LINKED_LIST [LINK] is
			-- Outgoing links of a place `a_place' in this network 
			-- (Recomputed on each call)
		do
			create Result.make
			from
				nodes.item (a_place).edges.start
			until
				nodes.item (a_place).edges.off
			loop
				Result.extend (nodes.item (a_place).edges.item_for_iteration.data)
				nodes.item (a_place).edges.forth
			end
		end
		
	links_between (a_place1, a_place2: PLACE): LINKED_LIST [LINK] is
			-- List of all links that directly connect the places `a_place1' and `a_place2'
			-- (Recomputed on each call)
		require
			a_place1_exists: a_place1 /= Void
			a_place2_exists: a_place2 /= Void
		local
			e: DS_LINKED_LIST [EDGE [PLACE, LINK]]
		do
			create Result.make
			e := edges_between (a_place1, a_place2)
			from
				e.start
			until
				e.off
			loop
				Result.extend (e.item_for_iteration.data)
				e.forth
			end
		end		

feature -- Removal

	prune_link (a_link: LINK) is
			-- Remove `a_link' from the transport network.
		do
			if not a_link.directed then
				remove_edges (a_link.from_place, a_link.to_place, a_link)
				remove_edges (a_link.to_place, a_link.from_place, a_link)
			else
				remove_edges (a_link.from_place, a_link.to_place, a_link)
			end
		end
		
end -- class NETWORK

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
