indexing
	description: 
		"[
			Constants for line and link type distinction.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class
	LINE_LINK_TYPE_CONSTANTS

feature -- Status report

	is_valid_type (a_type: STRING): BOOLEAN is
			-- Is `a_type' representing a valid link and line type?
		require
			a_type_exists: a_type /= Void
			a_type_not_empty: not a_type.is_empty
		do
			Result := a_type.is_equal (Bus_type) or a_type.is_equal (Metro_type) or a_type.is_equal (Tram_type) or a_type.is_equal (Street_type) or a_type.is_equal (Taxi_type) or a_type.is_equal (Walking_type) or a_type.is_equal (Rail_type)		
		end
		
	is_walking (a_type: STRING): BOOLEAN is
			-- Is `a_type' representing `Walking_type'?
		require
			a_type_exists: a_type /= Void
			a_type_not_empty: not a_type.is_empty
		do
			Result := equal (a_type, Walking_type)
		end
		
	is_bus (a_type: STRING): BOOLEAN is
			-- Is `a_type' representing `Bus_type'?
		require
			a_type_exists: a_type /= Void
			a_type_not_empty: not a_type.is_empty
		do
			Result := equal (a_type, Bus_type)
		end
		
	is_public_transport (a_type: STRING): BOOLEAN is
			-- Is `a_type' one of the public transportation types?
		require
			a_type_exists: a_type /= Void
			a_type_not_empty: not a_type.is_empty
		do
			Result := a_type.is_equal (Bus_type) or a_type.is_equal (Metro_type) or a_type.is_equal (Tram_type) or a_type.is_equal (Rail_type)		
		end
	
feature -- Constants

	Rail_type: STRING is "rail"
			-- Type rail
	
	Bus_type: STRING is "bus"
			-- Type bus
	
	Metro_type: STRING is "metro"
			-- Type metro
	
	Tram_type: STRING is "tram"
			-- Type tram
	
	Street_type: STRING is "street"
			-- Type street

	Taxi_type: STRING is "taxi"
			-- Type taxi
	
	Walking_type: STRING is "walking"
			-- Type walking

end -- class LINE_LINK_TYPE_CONSTANTS

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------

