indexing
	description: 
		"[
			XML processors for <point> elements. Example: <point x="3.2" y="1.7">.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class POINT_NODE_PROCESSOR inherit

	NODE_PROCESSOR

create
	make

feature -- Access

	Name: STRING is "point"
			-- Name of node to process
			
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		once
			Result := << "x", "y" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		local
			x: INTEGER
			y: INTEGER
			s: STRING
			c: COORDINATE
		do
			if not has_attribute ("x") and has_attribute ("y") then
				set_error (Mandatory_attribute_missing, << "x", "y" >>)
			elseif not ((is_attribute_integer ("x") and is_attribute_integer ("y")) or
					(is_attribute_double ("x") and is_attribute_double ("y")))
			then
				set_error (Wrong_attribute_type, << "x", "y" >>)
			else
				x := attribute_integer ("x")
				y := attribute_integer ("y")
				if x >= 0 and y >= 0 then
					create c
					c.set (x, y)
					parent.send_data (c)
				else
					if x < 0 then
						s := "x = " + x.out
					else
						s := "y = " + y.out
					end
					set_error (Invalid_attribute_value, << s >>)
				end
			end
		end

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
