indexing
	description: 
		"[
			XML processors for <place> nodes.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

class PLACE_NODE_PROCESSOR inherit

	NODE_PROCESSOR

create
	make

feature -- Access

	Name: STRING is "place"
			-- Name of node to process
			
	place: PLACE
			-- Reference to node

	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		once
			Result := << "name" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		do
			if not has_attribute ("name") then
				set_error (Mandatory_attribute_missing, << "name" >>)
			elseif city_factory.city.has_place (attribute ("name")) then
				set_error (Duplicate_name, << attribute ("name") >>)
			else
				city_factory.build_place (attribute ("name"), city)
				set_target (city_factory.place)
			end

			if has_subnodes then
				process_subnodes
			end
		end
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|		Michela Pedroni <pedronim@inf.ethz.ch>
--|
--|--------------------------------------------------------
