indexing
	description: 
		"[
			XML processors for <city> nodes".
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class CITY_NODE_PROCESSOR inherit

	NODE_PROCESSOR
	
create
	make

	
feature -- Access

	Name: STRING is "city"
			-- Name of node to process
			
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		once
			Result := << "name" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		do
			if has_attribute ("name") then
				city_factory.build_city (attribute ("name"))
			end
			
			if has_subnodes then
				process_subnodes
			end
		end		
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|
--|--------------------------------------------------------
