indexing
	description: 
		"[
			Abstract displayer factory
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

deferred class DISPLAYER_FACTORY

feature -- Factory

	build_city_displayer (a_city: CITY) is
			-- New displayer for `a_city'
		deferred
		end

	build_line_displayer (a_line: LINE) is
			-- New displayer for `a_line'
		deferred
		end
		
	build_place_displayer (a_place: PLACE) is
			-- New displayer for `a_place'
		deferred
		end

	build_link_displayer (a_link: LINK) is
			-- New displayer for `a_link'
		deferred
		end
		
	build_station_displayer (a_station: STATION) is
			-- New displayer for `a_station'
		deferred
		end

feature -- Access

	new_city_displayer: DISPLAYER is
			-- City displayer created by a call to `build_city_displayer'
		deferred
		end

	new_line_displayer: DISPLAYER is
			-- Line displayer created by a call to `build_line_displayer'
		deferred
		end

	new_link_displayer: DISPLAYER is
			-- Link displayer created by a call to `build_link_displayer'
		deferred
		end

	new_place_displayer: DISPLAYER is
			-- Place displayer created by a call to `build_place_displayer'
		deferred
		end

	new_station_displayer: DISPLAYER is
			-- Station displayer created by a call to `build_station_displayer'
		deferred
		end

end -- class DISPLAYER_FACTORY

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
