indexing
	description: 
		"[
			Abstract class for objects that handle the display of displayable objects.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

deferred class DISPLAYER

feature -- Initialization

	make (a_displayable: DISPLAYABLE) is
			-- Set `element' to `a_displayable'.
		require
			a_displayable_exists: a_displayable /= Void
		do
			element := a_displayable
			element.set_displayer (Current)
		end

feature -- Access

	element: DISPLAYABLE
			-- Element for which this displayer handles the display

invariant
	
	element_is_set: element /= Void
	element_has_displayer: element.displayer = Current
	
end -- class DISPLAYER

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
