indexing
	description: 
		"[
			City objects with a transportation network consisting of lines, links and places.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

class CITY inherit
	
	DISPLAYABLE
	
create
	make
	
feature -- Initialization


	make (a_name: STRING) is
			-- Create city with name `a_name'.
		require
			a_name_exists: a_name /= Void
			a_name_not_empty: not a_name.is_empty
		do
			create name.make_from_string (a_name)
			create transport_network.make
			create lines.make (30)
			create places.make (30)
			create links.make
		ensure
			name_is_correct: equal (name, a_name)
		end
		
feature -- Access

	transport_network: NETWORK
			-- Transportation network on which all the calculations are performed
	
	lines: DS_HASH_TABLE [LINE, STRING]
			-- Container in which all transportation lines (e.g. streets, metro lines, bus lines, etc.) are stored 
	
	places: DS_HASH_TABLE [PLACE, STRING]
			-- Container in which all places of the city are stored
	
	name: STRING
			-- Name of the city
	
	links: DS_LINKED_LIST [LINK]
			-- Container in which all links of the city are stored
	
feature -- Status report

	has_place (a_name: STRING): BOOLEAN is
			-- Is the place with name `a_name' part of the city?
		require
			a_name_exists: a_name /= Void
			a_name_not_empty: not a_name.is_empty
		do
			Result := places.has (a_name)
		end
	
end -- class CITY

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
