indexing
	description: 
		"[
			Console for output in the application.
		 ]"	
			
	author: "Michela Pedroni & Rolf Bruderer, ETH Zurich"
	date: "$Date: 2004/10/20 15:26:19 $"
	revision: "$Revision: 1.4 $"

class
	TRAFFIC_CONSOLE

inherit
	
	EV_TEXT
		rename 
			show as show_widget,
			append_text as buggy_append_text
		export
			{NONE} buggy_append_text 
		end

feature -- Basic operations

	show (an_object: ANY) is
			-- Output description of `an_object'.
		do
			append_text (an_object.out + "%N")
		end
		
	append_text (a_text: STRING) is
			-- Append `a_text' to `text'.
		require
			not_destroyed: not is_destroyed
			text_not_void: a_text /= Void
			no_carriage_returns: not a_text.has ('%R')
		local
			assertion_checking: BOOLEAN
		do
			-- Turn assertion checking temporarily off if on linux to make buggy_append_text work.
 			assertion_checking := (create {ISE_RUNTIME}).check_assert (False)
			
			-- Call the buggy feature.
			buggy_append_text (a_text)
			
			-- Set assertion checking back to initial state.
			assertion_checking := (create {ISE_RUNTIME}).check_assert (assertion_checking)
		ensure		
			text_appended: check_text_modification (old text, a_text)	
			caret_may_have_moved:
		end
		
		
end -- class TRAFFIC_CONSOLE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|		Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
