indexing
	description:
		"[
			Animation consisting out of two steps
		 ]"

	status:	"See notice at end of class"
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

deferred class TWO_STEP_ANIMATION inherit	

	TIMEABLE
	
feature -- Access

	End_time: INTEGER is
			-- End time of animation
		once
			Result := 5000
		end
		
feature -- Status report

	is_ready: BOOLEAN is True

feature -- Basic operations

	execute_timed_action (t: INTEGER) is
			-- Execute action at time `t'.
		do
			if t < end_time then
				execute_animation (t)
			end
		end
		
	reset is
			-- Reset if timeline is stopped.
		do
			if has_timeline and then timeline.has (Current) then
				unregister
			end
		end
		
	set_up is
			-- Set timeline and insert `Current'.
		local
			env: EV_ENVIRONMENT
			mc: MAIN_CONTROLLER
			last: TWO_STEP_ANIMATION
		do
			
			create env
			mc ?= env.application
			timeline := mc.timeline
			check
				timeline /= Void
			end
			if not timeline.is_empty then
				last ?= timeline.last
			end

			if not timeline.running and is_ready and not timeline.has (Current) and last /= Void then
				set_start_time (last.start_time + last.end_time)
			end	
			timeline.extend (Current)
			reset_agent := agent reset
			timeline.add_stop_action (reset_agent)
		end

	execute_animation (t: INTEGER) is
			-- Execute animation depending on `t'.
		do
			if t = 0 then
				first_action
				timeline.Canvas.refresh
			elseif t = end_time // 2 then
				second_action
				timeline.Canvas.refresh
			end
		end

	first_action is
			-- Execute first action.
		deferred
		end

	second_action is
			-- Execute second action.
		deferred
		end
		
feature -- Agents
	
	reset_agent: PROCEDURE [ANY, TUPLE []]
			-- Agent for calling `reset'
	
end -- class TWO_STEP_ANIMATION

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
