indexing
	description:
		"[
			Class that supports the preview example
		 ]"

	status:	"See notice at end of class"
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

deferred class TOURISM 

inherit

	EXECUTABLE
	
	SHARED_CITY

feature {NONE} -- Animation objects

	Paris: PARIS is
			-- Map of Paris
		once
			create Result
		ensure
			Result_exists: Result /= Void
		end

	Louvre: LOUVRE is
			-- The Louvre
		local
			mc: MAIN_CONTROLLER
		once
			create Result.make
			mc ?= (create {EV_ENVIRONMENT}).application
			check
				main_controller_exists: mc /= Void
			end
			Result.set_timeline (mc.timeline)
		ensure
			Result_exists: Result /= Void
			timeline_set: Result.has_timeline
		end

	Line8: LINE8 is
			-- Metro line 8
		local
			mc: MAIN_CONTROLLER
		once
			create Result.make
			mc ?= (create {EV_ENVIRONMENT}).application
			check
				main_controller_exists: mc /= Void
			end
			Result.set_timeline (mc.timeline)
		ensure
			Result_exists: Result /= Void
			timeline_set: Result.has_timeline
		end
	
	Route1: DISPLAYABLE_ROUTE is
			-- route #1
		local
			mc: MAIN_CONTROLLER
		once
			create Result.make_from_origin_and_destination (city.places.item ("Station Madeleine"), city.places.item ("Tour Eiffel"))
			mc ?= (create {EV_ENVIRONMENT}).application
			check
				main_controller_exists: mc /= Void
			end
			Result.set_timeline (mc.timeline)
		ensure
			Result_exists: Result /= Void
			timeline_set: Result.has_timeline
		end
		
feature -- Basic operations

	explore is
			-- To be defined in PREVIEW.
		deferred			
		end

	run is
			-- Called when button in example panel is pressed.
		local
			env: EV_ENVIRONMENT
			mc: MAIN_CONTROLLER
			timeline: TIMELINE
		do
			create env
			mc ?= env.application
			timeline := mc.timeline
			check
				timeline /= Void
			end
			if timeline.running then				
				timeline.stop
			end
			timeline.wipe_out
			timeline.reset
			explore
			timeline.start
		end
	
feature {NONE} -- Constants

	Start_time: INTEGER is 0
			-- Start time of animation

end -- class TOURISM

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
