indexing
	description:
		"Predefined objects"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.5 $"

deferred class PREDEFINED_OBJECTS inherit

	EXECUTABLE
	
	SHARED_CITY
	
	DISPLAYER_ACCESSOR
	
feature -- Basic operations

	run is
			-- Execute on button press.
		local
			mc: MAIN_CONTROLLER
		do
			(create {PARIS}).display
			mc ?= (create {EV_ENVIRONMENT}).application
			if not mc.timeline.is_empty and mc.timeline.running then
				mc.timeline.stop
			end
			mc.timeline.wipe_out
			mc.timeline.reset
			make
			set_city_displayer (city)
			city_displayer.build
			mc.main_window.canvas.refresh
			if not mc.timeline.is_empty and not mc.timeline.running then
				mc.timeline.start
			end
		end
		
	make is
			-- To be defined in QUERIES. 
		deferred
		end
		
feature {NONE} -- Predefined objects (Stations)

	Station_Balard: PLACE is
			-- Station Balard
		once
			Result := city.places.item ("Station Balard")
		ensure
			Result_exists: Result /= Void
		end
		
	Station_Issy: PLACE is
			-- Station Issy
		once
			Result := city.places.item ("Station Mairie d'Issy")
		ensure
			Result_exists: Result /= Void
		end
		
	Station_Montrouge: PLACE is
			-- Station Montrouge
		once
			Result := city.places.item ("Station Chatillon - Montrouge")
		ensure
			Result_exists: Result /= Void
		end		
		
	Station_Gare_de_Lyon: PLACE is
			-- PLACE Gare de Lyon
		once
			Result := City.places.item ("Station Gare de Lyon")
		ensure
			Result_exists: Result /= Void
		end
		
	Station_Invalides: PLACE is
			-- Station Invalides
		once
			Result := city.places.item ("Station Invalides")
		ensure
			Result_exists: Result /= Void
		end

	Station_Madeleine: PLACE is
			-- Station Madeleine
		once
			Result := city.places.item ("Station Madeleine")
		ensure
			Result_exists: Result /= Void
		end

	Station_Bobigny_Pablo_Picasso: PLACE is
			-- Station Bobigny - Pablo Picasso
		once
			Result := city.places.item ("Station Bobigny - Pablo Picasso")
		ensure
			Result_exists: Result /= Void
		end

	Station_La_Fourche: PLACE is
			-- Station La Fourche
		once
			Result := city.places.item ("Station La Fourche")
		ensure
			Result_exists: Result /= Void
		end

	Station_Bastille: PLACE is
			-- Station Bastille
		once
			Result := city.places.item ("Station Bastille")
		ensure
			Result_exists: Result /= Void
		end
		
	Station_Concorde: PLACE is
			-- Station Concorde
		once
			Result := city.places.item ("Station Concorde")
		ensure
			Result_exists: Result /= Void
		end
		
	Station_Republique: PLACE is
			-- Station Republique
		once
			Result := city.places.item ("Station Republique")
		ensure
			Result_exists: Result /= Void
		end

	Station_La_Motte_Picquet_Grenelle: PLACE is
			-- Station La Motte - Picquet - Grenelle
		once
			Result := city.places.item ("Station La Motte - Picquet - Grenelle")
		ensure
			Result_exists: Result /= Void
		end
		
feature {NONE} -- Predefined objects (Lines)

	Line8: SIMPLE_LINE is
			-- Metro line 8
		once
			Result := create {SIMPLE_LINE}.make (city.lines.item ("Metro 8"))
		ensure
			Result_exists: Result /= Void
		end

feature {NONE} -- Implementation

	show_spot (a_place: PLACE) is
			-- Spotlight `a_place'.
		require
			a_place_exists: a_place /= Void
		local
			e: PLACE_SPOTLIGHTER
		do
			create e.make (a_place)
			e.set_up
		end

end -- class PREDEFINED_OBJECTS

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
