indexing
	description:
		"The Louvre"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class LOUVRE inherit

	TWO_STEP_ANIMATION
		rename
			set_up as spotlight
		redefine
			out,
			reset
		end
	
	SHARED_CITY
		undefine
			out 
		end
		
	DISPLAYER_ACCESSOR
		undefine 
			out 
		end
	
create
	make

feature {NONE} -- Initialization

	make is
			-- Create object.
		do
			internal_element := city.places.item ("Musee du Louvre")
		end

feature -- Basic operations

	first_action is
			-- Execute first action.
		do
			set_place_displayer (internal_element)
			place_displayer.mark
		end

	second_action is
			-- Execute second action.
		do
			set_place_displayer (internal_element)
			place_displayer.unmark
		end

	reset is
			-- 
		do
			set_place_displayer (internal_element)
			place_displayer.unmark
			Precursor
		end
		
feature -- Output

	out: STRING is
			-- Returns name and some information on the Louvre
		do
			if internal_element /= Void then
				Result := internal_element.description
			else
				Result := "No info available"
			end
		end
		
feature {NONE} -- Implementation

	internal_element: PLACE
			-- Internal place
		
end -- class LOUVRE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
