indexing
	description:
		"[
			Metro line 8
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class LINE8 inherit

	TWO_STEP_ANIMATION
		rename
			set_up as highlight
		undefine
			out
		redefine
			reset
		end

	SHARED_CITY
		undefine out end
		
	DISPLAYER_ACCESSOR
		undefine out end

create
	make

feature {NONE} -- Initialization

	make is
			-- Create object.
		do
			internal_element := city.lines.item ("Metro 8")
		end

feature -- Basic operations

	first_action is
			-- Execute first action.
		do
			set_line_displayer (internal_element)
			line_displayer.highlight
		end

	second_action is
			-- Execute second action.
		do
			set_line_displayer (internal_element)
			line_displayer.unhighlight
		end

	reset is
			-- Reset if animation is cancelled.
		do
			set_line_displayer (internal_element)
			if line_displayer.highlighted then
				line_displayer.unhighlight
			end
			Precursor
		end
		
feature -- Output

	out: STRING is
			-- Returns name and some information on the Louvre
		do
			if internal_element /= Void then
				Result := internal_element.description
			else
				Result := "No info available%N"
			end
		end
		
feature {NONE} -- Implementation

	internal_element: LINE
		
end -- class LINE8

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
