indexing
	description: 
		"[
			Registry for exercise and example buttons.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.4 $"

class BUTTON_REGISTRY
	
create
	make
	
feature -- Initialization

	make is
			-- Setup the button registry.
		do
			create examples.make (20)
			create exercises.make (20)
		ensure
			examples_exists: examples /= Void
			exercises_exists: exercises /= Void
		end

feature -- Basic operations

	set_up_examples is
			-- Register examples in the button panel.
		do
			examples.extend (create {PREVIEW}, "Preview")
			examples.extend (create {QUERIES}, "Queries")
			examples.extend (create {COMMANDS}, "Commands")
			examples.extend (create {LINE_BUILDING}, "Fancy")
			examples.extend (create {LOOPS}, "Loops")
		end

	set_up_exercises is
			-- Register exercises in the button panel.
		do
			exercises.extend (create {TEST_EXERCISE}, "Test")
		end

feature {MAIN_CONTROLLER} -- Implementation

	examples: HASH_TABLE [EXECUTABLE, STRING]
			-- Storage for examples
			
	exercises: HASH_TABLE [EXECUTABLE, STRING]
			-- Storage for exercises
	
end -- class BUTTON_REGISTRY

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
