indexing
	description: "Constants used in MAIN_WINDOW"
	status:	"See notice at end of class"
	author: "Marcel Kessler, ETH Zurich"
	date: "$Date: 2004/10/15 14:06:10 $"
	revision: "$Revision: 1.7 $"
	version: "0.1.2.1"

class
	MAIN_WINDOW_CONSTANTS
	
inherit
	KL_SHARED_FILE_SYSTEM
	
feature -- Constants (Numbers)

	First_mode_value,
	Selection_mode,
	Move_mode,
	Information_mode,
	Last_mode_value: INTEGER is unique
			-- Values for the modes of the user interface

	Button_padding: INTEGER is 8
			-- Padding of the button panel

	Default_zoom: REAL is 1.0
			-- Default zoom factor
		
	Zoom_factor_seamless: REAL is 0.01
			-- Seamless zoom factor
		
	Zoom_factor_stepwise: REAL is 0.05
			-- Stepwise zoom factor

	Window_title: STRING is "FLAT_HUNT"
			-- Title of the window

	Window_width: INTEGER is 1024
			-- Initial width for this window

	Window_height: INTEGER is 768
			-- Initial height for this window
			
	Pan_distance: INTEGER is 30
			-- Distance to move the Map
			
	Delta_t: REAL is 0.02
			-- The delta time between two timeline increments
		
	Scaling_reference: REAL is 634.0
			-- The reference value for line width scaling

	Button_ok_text: STRING is "OK"
			-- String for "OK" buttons.

feature -- Constants (Names of window items, tooltips)

	File_menu_text: STRING is "&File"
			-- String for menu "File"

	File_open_item_text: STRING is "&Open Map...%TCtrl+O"
			-- String for menu "File/Open"

	File_start_item_text: STRING is "&Start...%T[Enter]"
			-- String for menu "File/Start"

	File_break_item_text: STRING is "&Break...%T[Space]"
			-- String for menu "File/Break"

	File_exit_item_text: STRING is "E&xit"
			-- String for menu "File/Exit"

	Help_menu_text: STRING is "&Help"
			-- String for menu "Help"

	Help_contents_item_text: STRING is "&Contents and Index"
			-- String for menu "Help/Contents and Index"

	Help_about_item_text: STRING is "&About..."
			-- String for menu "Help/About"

	Image_directory_name: STRING is "application_images"
			-- Directory for images

	Selection_tooltip: STRING is "Tool to select places"
			-- Tooltip for selection button

	Zoom_in_tooltip: STRING is "Zoom in"
			-- Tooltip for zoom in button

	Zoom_out_tooltip: STRING is "Zoom out"
			-- Tooltip for zoom out button

	Center_tooltip: STRING is "Tool to center on current player"
			-- Tooltip for information button

	Info_cursor_shape: STRING is "info_cursor"
			-- Image of information cursor shape
			
	Move_button_image: STRING is "move.png"
			-- Image of move button

	Move_cursor_shape: STRING is "move_cursor"
			-- Image of move cursor shape
			
	Move_tooltip: STRING is "Tool to move the map"
			-- Tooltip for selection button

	Cursor_hotspot_x: INTEGER is 16
			-- X coordinate of cursor hotspot

	Cursor_hotspot_y: INTEGER is 16
			-- Y coordinate of cursor hotspot
			
	Name_display_tooltip: STRING is "Display names on/off"
	
feature -- Constants (About)

	About_title: STRING is "About FLAT_HUNT"
			-- Default title for the dialog window.

	About_message: STRING is
		"FLAT_HUNT Version 1.0%N%
		%%N%
		%South  Park icons courtesy of%
		%Trey Parker & Matt Stone%N%
		%%N%
		%Copyright (C) 2004 ETH Zurich"

	About_icon: STRING is "landmark_info"
			-- Name of about icon

feature -- Constants (Game_dialog)

	Dialog_title: STRING is "Game settings"
			-- Default title for the game dialog window.

	Dialog_icon: STRING is "shortest_path"
			-- Name of dialog icon
			
	Dialog_multiplayer_title: STRING is "Multiplayer settings"
			-- Default title for the multiplayer dialog window

feature -- Constants (Images)

	Application_icon: STRING is "application_icon_16x16"
			-- Name of application icon

	Button_images: ARRAY [STRING] is
			-- Names of images for tool bar
		once
			Result := << "zoom_in", "zoom_out", "selection", "move", 
				"center", "name_display", "eis", "shortest_path" >>
		ensure
			Result_exists: Result /= Void
			Result_not_empty: not Result.is_empty
		end

	Image_directory: STRING is
		local
			e: EXECUTION_ENVIRONMENT
		once
			create e
			Result := File_system.pathname_from_file_system (File_system.current_working_directory + "\images", Windows_file_system)
		end
	
	Inactivity_suffix: STRING is "_inactive"
			-- Suffix for inactive button images
			
	Image_extension: STRING is 
		once
			if File_system = Unix_file_system then
				Result := ".png"
			else
				Result := ".ico"
			end
		end

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
