indexing
	description: "Zustndig fr das Abfragen von Keyboard-Zustnden"
	author: "Bucher Peter"
	date: "$20.1.05$"
	revision: "$1.0$"

class
	INPUT
create
	init

feature -- Init
	init is
			-- Initialisiert Event-loop zum abfragen der Tastatur
		do
			create event_loop.make_poll
			event_loop.key_down_event.subscribe (agent buttonpressed (?))
			event_loop.quit_event.subscribe (agent handle_quit_event (?))
			event_loop.outside_event.subscribe (agent handle_outside_event)
			event_loop.mouse_button_down_event.subscribe (agent mouse_click_event (?))
		end
feature -- Events

	mouse_click_event (mouse_event: ESDL_MOUSEBUTTON_EVENT) is
			-- 
		do
			mouse_click_x := mouse_event.sdl_mousebutton_event_struct.x
			mouse_click_y := mouse_event.sdl_mousebutton_event_struct.y
		end
		

	handle_quit_event (quit_event: ESDL_QUIT_EVENT) is
			-- Falls Fenster schliessen von ausserhalb aufgerufen wurde
		do
			esc_pressed := true
		end
		
	
	key_wait_counter : INTEGER -- damit der event_loop abgebrochen wird
		
	handle_outside_event is
			-- Wird vom event_loop aufgerufen, falls keine anderen events anstehen. zustndig fr den abbruch des loops
		do
			if key_wait_counter > 5 then
				event_loop.stop				
				key_wait_counter := 0
			else
				key_wait_counter := key_wait_counter + 1
			end

		end
		
	buttonpressed (keyboard_event: ESDL_KEYBOARD_EVENT) is
			-- Routine zur behandlung von Keyboard_events
		require
			event_not_void: keyboard_event /= Void
		local
			keycode: INTEGER
			key: ESDL_KEY
		do
			create key.make
			keycode := key.scan (key.sdlk_escape)
			if	keycode /= 0 then event_loop.stop; esc_pressed := true end
			
			keycode := key.scan (key.sdlk_left)
			if keycode /= 0 then left_pressed := true end
			keycode := key.scan (key.sdlk_right)
			if keycode /= 0 then right_pressed := true end
			keycode := key.scan (key.sdlk_up)
			if keycode /= 0 then up_pressed := true end
			keycode := key.scan (key.sdlk_down)
			if keycode /= 0 then down_pressed := true end
			
			keycode := key.scan (key.sdlk_return)
			if keycode /= 0 then enter_pressed := true end
			keycode := key.scan (key.sdlk_period)
			if keycode /= 0 then dot_pressed := true end
			
			
			keycode := key.scan (key.sdlk_0)
			if keycode /= 0 then pressed_number := 10; number_pressed := true end
			keycode := key.scan (key.sdlk_1)
			if keycode /= 0 then pressed_number := 1; number_pressed := true end
			keycode := key.scan (key.sdlk_2)
			if keycode /= 0 then pressed_number := 2; number_pressed := true end
			keycode := key.scan (key.sdlk_3)
			if keycode /= 0 then pressed_number := 3; number_pressed := true end
			keycode := key.scan (key.sdlk_4)
			if keycode /= 0 then pressed_number := 4; number_pressed := true end
			keycode := key.scan (key.sdlk_5)
			if keycode /= 0 then pressed_number := 5; number_pressed := true end
			keycode := key.scan (key.sdlk_6)
			if keycode /= 0 then pressed_number := 6; number_pressed := true end
			keycode := key.scan (key.sdlk_7)
			if keycode /= 0 then pressed_number := 7; number_pressed := true end
			keycode := key.scan (key.sdlk_8)
			if keycode /= 0 then pressed_number := 8; number_pressed := true end
			keycode := key.scan (key.sdlk_9)
			if keycode /= 0 then pressed_number := 9; number_pressed := true end

			event_loop.stop			
		end	
		
feature -- Key Input
	GetKey is
			-- Startet den Event_loop um das Keyboard abzufragen.  
		do
			left_pressed := false
			right_pressed := false
			down_pressed := false
			up_pressed := false
			number_pressed := false
			esc_pressed := false
			dot_pressed := false
			enter_pressed := false
			pressed_number := 0
			
			mouse_click_x := 0
			mouse_click_y := 0
			
			event_loop.start
			event_loop.dispatch
		end
		
	GetMouseX : INTEGER is
			-- Gibt mouse_click_x zurck
		do
			Result := mouse_click_x
		end
		
	GetMouseY : INTEGER is
			-- Gibt mouse_click_y zurck
		do
			Result := mouse_click_y
		end
		
	GetNumber : INTEGER is
			-- Gibt Nummer zurck falls eine gedrckt wurde
		require
--			number_pressed: number_pressed = true
--			pressed_number_valid: pressed_number >= 0 and pressed_number <= 9
		do
			Result := pressed_number
		end
		
		
	IsNumber : BOOLEAN is
			-- true wenn eine Nummer gedrckt wurde
		do
			Result := number_pressed
		end
		
	Is_Key_Up : BOOLEAN is
			-- true wenn Pfeiltaste nach oben gedrckt
		do
			Result := up_pressed
		end
		
	Is_Key_Down : BOOLEAN is
			-- true wenn Pfeiltaste nach unten gedrckt
		do
			Result := down_pressed
		end
		
	Is_Key_Left : BOOLEAN is
			-- true wenn Pfeiltaste nach links gedrckt
		do
			Result := left_pressed
		end
		
	Is_Key_Right : BOOLEAN is
			-- true wenn Pfeiltaste nach rechts gedrckt
		do
			Result := right_pressed
		end
		
	Is_Key_Dot : BOOLEAN is
			-- true wenn . gedrckt
		do
			Result := dot_pressed
		end
	
	Is_Key_Enter : BOOLEAN is
			-- true wenn Enter gedrckt
		do
			Result := enter_pressed
		end
		
	Is_Key_Esc : BOOLEAN is
			-- true wenn Esc gedrckt
		do
			Result := esc_pressed
		end

feature {NONE} -- Objects
	event_loop: ESDL_EVENT_LOOP
	
	left_pressed : BOOLEAN
	right_pressed : BOOLEAN
	up_pressed : BOOLEAN
	down_pressed : BOOLEAN
	enter_pressed : BOOLEAN
	dot_pressed : BOOLEAN
	esc_pressed : BOOLEAN
	
	number_pressed : BOOLEAN
	pressed_number : INTEGER
	
	mouse_click_x : INTEGER
	mouse_click_y : INTEGER

end -- class INPUT
