indexing
	description: "Objects that ..."
	author: ""
	date: "$Date$"
	revision: "$Revision$"

class
	GAME

inherit 
		
	ESDL_CONSTANTS
		export
			{NONE} all
		end

create
	make
	
feature --Creation
	
	make is
			-- Create the main application.
	local
		firstrun : BOOLEAN
	do
		create board.make (7, 6, 4)
		create in.init
		create {HUMAN} player1.make(current)
		
		board.showboard
		
		if isnetwork then
				create {NET}player2.make(current, isserver, "127.0.0.1", 15000)
				else
					create {HUMAN} player2.make(current)
		end
		
		from
			firstrun := true
		until
			board.is_gameover
			or in.is_key_esc
			or abort_condition
		loop
			
			if (server or not firstrun) or not isnetwork then
				
			
				in.getkey -- reset the input vars.
				from
				until
					in.getmousey > 50 and in.getmousey-50 < board.get_height * board.stoneblue.get_height
					and in.getmousex > 10 and in.getmousex-10 < board.get_width * board.stoneblue.get_width 
					or 
					in.is_key_esc
					or
					in.isnumber 
					and then board.get_width>=in.getnumber
				loop
					in.getkey
				end
				
				if in.isnumber then
					create move.makex (in.getnumber-1)
				else
					create move.makex ((in.getmousex - 10)// board.stoneblue.get_width)
				end

				player1.domove (move)
			
				if isnetwork then
					player2.domove(void)
				end
			else
				player2.domove(void)
			end
			firstrun := false
		end
		
		from
		until
			in.is_key_esc
		loop
			in.getkey
		end
end


feature --Get Objects

	getin: INPUT is
			-- 
			do
				Result := in				
			end
	
	getmove: MOVE is
			-- 
			do
				Result := move				
			end
	
	getboard: BOARD is
			-- 
			do
				Result := board				
			end
		
	getplayer1: PLAYER is
			-- 
			do
				Result := player1
			end
	
	getplayer2: PLAYER is
			-- 
			do
				Result := player2
			end
		
	isnetwork: BOOLEAN is
			-- 
			do
				Result := network
			end
		
	isserver: BOOLEAN is
			-- 
			do
				Result := server
			end
		
		
feature {NONE} -- Implementation
	
	in : INPUT
	move: MOVE
	board : BOARD
	player1: PLAYER
	player2: PLAYER

	network: BOOLEAN is false
	server: BOOLEAN is  false
	
	abort_condition : BOOLEAN
end -- class GAME
